package com.estimote.managemet_sdk.configuration_manager.internals

import java.util.regex.Pattern

internal class Version(val major: Int, val minor: Int, val patch: Int?) : Comparable<Version> {

    override fun compareTo(another: Version): Int {
        var compareValue = Integer.valueOf(major)!!.compareTo(another.major)
        if (compareValue == 0) {
            compareValue = Integer.valueOf(minor)!!.compareTo(another.minor)
            if (compareValue == 0) {
                if (patch != null && another.patch != null) {
                    compareValue = patch.compareTo(another.patch)
                }
            }
        }
        return compareValue
    }


    companion object {
        private val VERSION_PATTERN = Pattern.compile("[A-B]*([0-9]+)\\.([0-9]+)(?:\\.([0-9])){0,1}(?:-([a-zA-z0-9_]+)){0,1}")

        fun fromString(textVersion: String): Version {
            val matcher = VERSION_PATTERN.matcher(textVersion)
            if (matcher.find()) {
                return Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)),
                        if (matcher.group(3) != null) Integer.parseInt(matcher.group(3)) else 0)
            } else {
                throw IllegalArgumentException("Wrong version format: " + textVersion)
            }
        }

        /**
         * Compares two strings with version
         * @param v1 first version
         * *
         * @param v2 second version
         * *
         * @return 1 if v1 > v2, 0 if v1 = v2, -1 if v1 < v2
         */
        fun compareStrings(v1: String, v2: String): Int {
            return fromString(v1).compareTo(fromString(v2))
        }
    }
}