package com.estimote.managemet_sdk.configuration_manager.cloud
import com.google.gson.annotations.SerializedName

/**
 * @author Estimote Inc. (contact@estimote.com)
 */


data class CloudMeshMessageBody(val data: ByteArray, val settingsVersion: Long)

data class CloudMeshMessage(val meshId: Long, val data: ByteArray, val settingsVersion: Long)

data class BufferConfirmationMessage(@SerializedName("message_buffer") val messageBuffer: String)

data class CloudDeviceId(val id: String)

data class CloudCommands(val commands: List<String>)

data class CloudMeshSettingsVersion(val settingsVersion: Int)

data class CloudMeshConfig(val meshId: Long, val deviceIds: List<String>)

data class CloudMeshConfigs(val cloudMeshConfigs: List<CloudMeshConfig> )

data class MeshSettingsConfirmationRequest(val identifier: String, @SerializedName("settings_version") val settingsVersion: Int)

data class MeshSettingsConfirmationResponse(val successes: List<String>, val errors: List<String>)

data class MeshScanReport(@SerializedName("settings_version") val settingsVersion: Int, @SerializedName("collected_at") val collectedAt: Long, val report: List<String>)

class MeshScanReportResponse