package com.estimote.managemet_sdk.configuration_manager

import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.management.ManagementCloud
import com.estimote.internal_plugins_api.legacy_settings.LegacySettingsManager
import com.estimote.internal_plugins_api.scanning.ScanningStack
import com.estimote.managemet_sdk.configuration_manager.dagger.DaggerManagementSDKComponent

import com.estimote.managemet_sdk.configuration_manager.dagger.ManagementSDKComponent
import com.estimote.managemet_sdk.configuration_manager.dagger.ManagementSDKModule
import okio.ByteString

object ManagementSDK {
    @JvmStatic internal var managementSdkComponent : ManagementSDKComponent? = null

    @JvmStatic fun initialize(managementCloud: ManagementCloud, legacySettingsManager: LegacySettingsManager, scanningStack: ScanningStack) {
        managementSdkComponent = DaggerManagementSDKComponent.builder()
                .managementSDKModule(ManagementSDKModule(managementCloud, legacySettingsManager, scanningStack))
                .build()
     }

    class ManagementCloudCredentials(appId: String,
                                     appToken: String) : CloudCredentials {

        override val basicAuthorisation: String by lazy { ByteString.encodeUtf8(appId + ":" + appToken).base64()}

    }
}