/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.managemet_sdk.use_case;

import com.estimote.internal_plugins_api.cloud.CloudDeviceId;
import com.estimote.internal_plugins_api.cloud.CloudManager;
import com.estimote.internal_plugins_api.cloud.CloudMeshMessage;
import com.estimote.internal_plugins_api.legacy_settings.LegacySettingsManager;
import com.estimote.managemet_sdk.internals.SyncableDeviceVisitorUseCase;
import com.estimote.managemet_sdk.internals.VisitableBeacon;
import com.estimote.managemet_sdk.use_case.SyncBeaconMeshMessageUseCase;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001a\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/estimote/managemet_sdk/use_case/SyncBeaconMeshMessageUseCase;", "Lcom/estimote/managemet_sdk/internals/SyncableDeviceVisitorUseCase;", "Lio/reactivex/Completable;", "cloudManager", "Lcom/estimote/internal_plugins_api/cloud/CloudManager;", "legacySettingsManager", "Lcom/estimote/internal_plugins_api/legacy_settings/LegacySettingsManager;", "(Lcom/estimote/internal_plugins_api/cloud/CloudManager;Lcom/estimote/internal_plugins_api/legacy_settings/LegacySettingsManager;)V", "onFirmwareVersionNotSupported", "onFirmwareVersionSupported", "device", "Lcom/estimote/managemet_sdk/internals/VisitableBeacon;", "useCaseMinFirmwareVersion", "", "whenCloudMeshMessageIsObtained", "Lio/reactivex/Observable;", "Lcom/estimote/internal_plugins_api/cloud/CloudMeshMessage;", "andConfirmCommandsArePushedToMesh", "kotlin.jvm.PlatformType", "finishUseCase", "Lcom/estimote/internal_plugins_api/cloud/CloudManager$RequestStatus;", "postUpdatedSettingsVersionToCloud", "saveItToTheDevice", "management-sdk_release"})
public final class SyncBeaconMeshMessageUseCase
extends SyncableDeviceVisitorUseCase<Completable> {
    private final CloudManager cloudManager;
    private final LegacySettingsManager legacySettingsManager;

    @Override
    @NotNull
    public String useCaseMinFirmwareVersion() {
        return "4.13.0";
    }

    @Override
    @NotNull
    public Completable onFirmwareVersionNotSupported() {
        Completable completable = Completable.complete();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.complete()");
        return completable;
    }

    @Override
    @NotNull
    public Completable onFirmwareVersionSupported(@NotNull VisitableBeacon device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Completable completable = this.andConfirmCommandsArePushedToMesh(this.postUpdatedSettingsVersionToCloud(this.saveItToTheDevice(this.whenCloudMeshMessageIsObtained(device)), device));
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"whenCloudMeshMessageIsOb\u2026CommandsArePushedToMesh()");
        return completable;
    }

    private final Observable<CloudMeshMessage> whenCloudMeshMessageIsObtained(VisitableBeacon device) {
        String string = device.getConfigurableDevice().deviceId.toHexString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"device.configurableDevice.deviceId.toHexString()");
        return this.cloudManager.getMeshMessageForDevice(new CloudDeviceId(string));
    }

    private final Observable<CloudMeshMessage> saveItToTheDevice(@NotNull Observable<CloudMeshMessage> $receiver) {
        Observable observable = $receiver.flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ SyncBeaconMeshMessageUseCase this$0;

            @NotNull
            public final Single<CloudMeshMessage> apply(CloudMeshMessage message) {
                LegacySettingsManager legacySettingsManager = SyncBeaconMeshMessageUseCase.access$getLegacySettingsManager$p(this.this$0);
                CloudMeshMessage cloudMeshMessage = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)cloudMeshMessage, (String)"message");
                return legacySettingsManager.saveMeshMessageToDevice(cloudMeshMessage);
            }
            {
                this.this$0 = syncBeaconMeshMessageUseCase;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMapSingle { mes\u2026essageToDevice(message) }");
        return observable;
    }

    private final Observable<CloudMeshMessage> postUpdatedSettingsVersionToCloud(@NotNull Observable<CloudMeshMessage> $receiver, VisitableBeacon device) {
        Observable observable = $receiver.flatMap(new Function<T, ObservableSource<? extends R>>(this, device){
            final /* synthetic */ SyncBeaconMeshMessageUseCase this$0;
            final /* synthetic */ VisitableBeacon $device;

            @NotNull
            public final Observable<CloudMeshMessage> apply(CloudMeshMessage message) {
                CloudManager cloudManager = SyncBeaconMeshMessageUseCase.access$getCloudManager$p(this.this$0);
                String string = this.$device.getConfigurableDevice().deviceId.toHexString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"device.configurableDevice.deviceId.toHexString()");
                CloudMeshMessage cloudMeshMessage = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)cloudMeshMessage, (String)"message");
                return cloudManager.updateSettingsVersion(string, cloudMeshMessage);
            }
            {
                this.this$0 = syncBeaconMeshMessageUseCase;
                this.$device = visitableBeacon;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMap { message -\u2026toHexString(), message) }");
        return observable;
    }

    private final Completable andConfirmCommandsArePushedToMesh(@NotNull Observable<CloudMeshMessage> $receiver) {
        return $receiver.flatMapCompletable((Function)new Function<CloudMeshMessage, CompletableSource>(this){
            final /* synthetic */ SyncBeaconMeshMessageUseCase this$0;

            @NotNull
            public final Completable apply(CloudMeshMessage it) {
                CloudManager cloudManager = SyncBeaconMeshMessageUseCase.access$getCloudManager$p(this.this$0);
                CloudMeshMessage cloudMeshMessage = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)cloudMeshMessage, (String)"it");
                return cloudManager.putMeshMessageBuffer(cloudMeshMessage);
            }
            {
                this.this$0 = syncBeaconMeshMessageUseCase;
            }
        });
    }

    private final Completable finishUseCase(@NotNull Observable<CloudManager.RequestStatus> $receiver) {
        return $receiver.flatMapCompletable((Function)finishUseCase.1.INSTANCE);
    }

    public SyncBeaconMeshMessageUseCase(@NotNull CloudManager cloudManager, @NotNull LegacySettingsManager legacySettingsManager) {
        Intrinsics.checkParameterIsNotNull((Object)cloudManager, (String)"cloudManager");
        Intrinsics.checkParameterIsNotNull((Object)legacySettingsManager, (String)"legacySettingsManager");
        this.cloudManager = cloudManager;
        this.legacySettingsManager = legacySettingsManager;
    }

    @NotNull
    public static final /* synthetic */ LegacySettingsManager access$getLegacySettingsManager$p(SyncBeaconMeshMessageUseCase $this) {
        return $this.legacySettingsManager;
    }

    @NotNull
    public static final /* synthetic */ CloudManager access$getCloudManager$p(SyncBeaconMeshMessageUseCase $this) {
        return $this.cloudManager;
    }
}

