/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.managemet_sdk.internals;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0000\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/estimote/managemet_sdk/internals/Version;", "", "major", "", "minor", "patch", "(IILjava/lang/Integer;)V", "getMajor", "()I", "getMinor", "getPatch", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "compareTo", "another", "Companion", "management-sdk_release"})
public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    @Nullable
    private final Integer patch;
    private static final Pattern VERSION_PATTERN;
    public static final Companion Companion;

    @Override
    public int compareTo(@NotNull Version another) {
        Intrinsics.checkParameterIsNotNull((Object)another, (String)"another");
        int compareValue = Intrinsics.compare((int)this.major, (int)another.major);
        if (compareValue == 0 && (compareValue = Intrinsics.compare((int)this.minor, (int)another.minor)) == 0 && this.patch != null && another.patch != null) {
            compareValue = Intrinsics.compare((int)this.patch, (int)another.patch);
        }
        return compareValue;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    @Nullable
    public final Integer getPatch() {
        return this.patch;
    }

    public Version(int major, int minor, @Nullable Integer patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    static {
        Companion = new Companion(null);
        VERSION_PATTERN = Pattern.compile("[A-B]*([0-9]+)\\.([0-9]+)(?:\\.([0-9])){0,1}(?:-([a-zA-z0-9_]+)){0,1}");
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bR\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/estimote/managemet_sdk/internals/Version$Companion;", "", "()V", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getVERSION_PATTERN", "()Ljava/util/regex/Pattern;", "compareStrings", "", "v1", "", "v2", "fromString", "Lcom/estimote/managemet_sdk/internals/Version;", "textVersion", "management-sdk_release"})
    public static final class Companion {
        private final Pattern getVERSION_PATTERN() {
            return VERSION_PATTERN;
        }

        @NotNull
        public final Version fromString(@NotNull String textVersion) {
            Intrinsics.checkParameterIsNotNull((Object)textVersion, (String)"textVersion");
            Matcher matcher = this.getVERSION_PATTERN().matcher(textVersion);
            if (matcher.find()) {
                return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0);
            }
            throw (Throwable)new IllegalArgumentException("Wrong version format: " + textVersion);
        }

        public final int compareStrings(@NotNull String v1, @NotNull String v2) {
            Intrinsics.checkParameterIsNotNull((Object)v1, (String)"v1");
            Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v2");
            return this.fromString(v1).compareTo(this.fromString(v2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

