package com.estimote.managemet_sdk

import com.estimote.internal_plugins_api.cloud.CloudManager
import com.estimote.internal_plugins_api.legacy_settings.LegacySettingsManager
import com.estimote.internal_plugins_api.scanning_stack.ScanningStack
import com.estimote.managemet_sdk.dagger.DaggerManagementSDKComponent
import com.estimote.managemet_sdk.dagger.ManagementSDKComponent
import com.estimote.managemet_sdk.dagger.ManagementSDKModule

object ManagementSDK {
    @JvmStatic internal var managementSdkComponent : ManagementSDKComponent? = null

    @JvmStatic fun initialize(cloudManager: CloudManager, legacySettingsManager: LegacySettingsManager, scanningStack: ScanningStack) {
        managementSdkComponent = DaggerManagementSDKComponent.builder()
                .managementSDKModule(ManagementSDKModule(cloudManager, legacySettingsManager, scanningStack))
                .build()
     }


}