package com.estimote.managemet_sdk

import com.estimote.internal_plugins_api.cloud.CloudManager
import com.estimote.internal_plugins_api.legacy_settings.LegacySettingsManager
import com.estimote.internal_plugins_api.scanning_stack.ScanningStack
import com.estimote.managemet_sdk.internals.ToVisitableForwardingSyncableDevice
import com.estimote.managemet_sdk.internals.VisitableBeacon
import com.estimote.managemet_sdk.use_case.SyncBeaconMeshMessageUseCase
import com.estimote.managemet_sdk.use_case.SyncCommandsToTheDeviceUseCase
import javax.inject.Inject


/**
 * This is the main API class for management SDK.
 */

class ConfigurationManager {
    @Inject lateinit var legacySettingsManager: LegacySettingsManager
    @Inject lateinit var cloudManager: CloudManager
    @Inject lateinit var scanningStack: ScanningStack

    init { ManagementSDK.managementSdkComponent?.inject(this) }


    interface SyncableDevicesScanCallback {
        fun onSyncableDevicesFound(syncableDevices: Collection<SyncableDevice>)
        fun onSyncableDevicesScanError(cause: Throwable)
    }

    fun scanForSyncableDevices(callback: SyncableDevicesScanCallback) {
        scanningStack.discoveryConfigurableDevices()
                .map { configurableDevices -> configurableDevices.map { ToVisitableForwardingSyncableDevice(VisitableBeacon(it), SyncCommandsToTheDeviceUseCase(cloudManager, legacySettingsManager),  SyncBeaconMeshMessageUseCase(cloudManager, legacySettingsManager)) } }
                .subscribe({ callback.onSyncableDevicesFound(it) }, {callback.onSyncableDevicesScanError(it)})
    }
}