package com.estimote.managemet_sdk.internals

import com.estimote.managemet_sdk.SyncableDevice
import io.reactivex.Completable
import io.reactivex.android.schedulers.AndroidSchedulers

internal class ToVisitableForwardingSyncableDevice(private val visitableDevice: SyncableDeviceVisitorUseCase.VisitableDevice, private val syncMeshMessageToDeviceUseCase: SyncableDeviceVisitorUseCase<Completable>) : SyncableDevice {

    override fun syncWithCloud(callback: SyncableDevice.SyncableDeviceCallback) {
        visitableDevice.accept(syncMeshMessageToDeviceUseCase).observeOn(AndroidSchedulers.mainThread()).subscribe({ callback.onCompleted() }, { callback.onError(it) })
    }
}