package com.estimote.managemet_sdk.dagger

import com.estimote.internal_plugins_api.cloud.CloudManager
import com.estimote.internal_plugins_api.legacy_settings.LegacySettingsManager
import com.estimote.internal_plugins_api.scanning_stack.ScanningStack
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

@Module
internal class ManagementSDKModule(private val cloudManager: CloudManager,
                                   private val legacySettingsManager: LegacySettingsManager,
                                   private val scanningStack: ScanningStack) {

    @Provides @Singleton fun provideCloudManager(): CloudManager = cloudManager

    @Provides @Singleton fun provideLegacySettingsManager(): LegacySettingsManager = legacySettingsManager

    @Provides @Singleton fun provideLegacyScanningStack(): ScanningStack = scanningStack


}