package com.estimote.indoorsdk_module.cloud

import android.support.annotation.Keep

/**
 * This is basic interface for communicating with Estimote Indoor Cloud.
 * To acquire concrete object use [IndoorCloudManagerFactory.create] method.
 * @See IndoorCloudManagerFactory
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Keep
interface IndoorCloudManager {

    /**
     * Fetch location with given id from Estimote Indoor Cloud.
     * Remember to init our SDK with your AppId/AppToken first.
     */
    fun getLocation(locationId: String, callback: CloudCallback<Location>)

    /**
     * Fetch all locations connected to your account.
     * Remember to init our SDK with your AppId/AppToken first.
     */
    fun getAllLocations(callback: CloudCallback<List<Location>>)

}