package com.estimote.indoorsdk_module.algorithm.sensor

import android.hardware.Sensor
import android.hardware.SensorManager
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers

/**
 * It just subscribes and unsubscribes the stream of sensor data and feeds motion detector with it.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class StepMotionDetectorSubscriber(observableSensors: ObservableSensors, val motionDetector: MotionDetector) {

    private val sensorType = Sensor.TYPE_STEP_DETECTOR
    private val sensorDelay = SensorManager.SENSOR_DELAY_NORMAL

    private var stepSensorObservable: Observable<EstimoteSensorEvent>

    init {
        if (observableSensors.hasSensor(sensorType)) {
            stepSensorObservable = observableSensors.observeSensorChanges(sensorType, sensorDelay)
        } else {
            stepSensorObservable = Observable.empty()
        }
    }

    fun subscribe() {
        stepSensorObservable
                .filter { it.containsSensorData }
                .subscribe { motionDetector.onEvent(it) }
    }

    fun unsubscribe() {
        stepSensorObservable.unsubscribeOn(AndroidSchedulers.mainThread())
    }


}