package com.estimote.indoorsdk_module.logging

import android.util.Log

internal class LogcatIndorLogger(private val tag: String): IndoorLogger {

    override fun verbose(message: String) {
        Log.v(tag, message)
    }

    override fun debug(message: String) {
        Log.d(tag, message)
    }

    override fun info(message: String) {
        Log.i(tag, message)
    }

    override fun warn(message: String) {
        Log.w(tag, message)
    }

    override fun error(message: String) {
        Log.e(tag, message)
    }
}