package com.estimote.indoorsdk_module.dagger.indoor_manager

import android.content.Context
import android.os.Build
import com.estimote.cloud_plugin.BuildConfig
import com.estimote.cloud_plugin.api.SdkInfo
import com.estimote.indoorsdk_module.analytics.*
import com.estimote.indoorsdk_module.cloud.*
import com.estimote.indoorsdk_module.cloud.analytics.AnalyticsCloudManager
import com.estimote.indoorsdk_module.cloud.analytics.AnalyticsIndoorCloudManager
import com.estimote.indoorsdk_module.common.threading.SchedulerProvider
import com.estimote.indoorsdk_module.common.time.DateFormatter
import com.estimote.indoorsdk_module.common.time.Timer

import dagger.Module
import dagger.Provides
import java.nio.charset.Charset
import java.nio.charset.CharsetEncoder
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class AnalyticsModule(private val context: Context,
                               private val location: Location,
                               private val cloudCredentials: CloudCredentials) {

    @Provides
    @Singleton
    fun provideGeneralInfo(): GeneralInfo {
        return GeneralInfoProvider().createGeneralInfo(context, location)
    }

    @Provides
    @Singleton
    fun provideAnalyticsEventRepository(): AnalyticsEventRepository = SQLiteAnalyticsEventRepository(context)

    @Provides
    @Singleton
    fun provideUserAgentProvider(asciiEncoder: CharsetEncoder) =
            CloudUserAgentProvider(context, SdkInfo(BuildConfig.VERSION_NAME, "EstimoteIndoorSDK", Build.VERSION.RELEASE), asciiEncoder)

    @Provides
    @Singleton internal fun provideAsciiEncoder() = Charset.forName("ASCII").newEncoder()

    @Provides
    @Singleton
    fun provideAnalyticsCloudManager(userAgentProvider: CloudUserAgentProvider): AnalyticsCloudManager {
        val headerInterceptor = HeaderInterceptor(context, cloudCredentials, userAgentProvider)
        val api = IndoorCloudApi.build("https://cloud.estimote.com/", headerInterceptor)
        return AnalyticsIndoorCloudManager(api)
    }

    @Provides
    @Singleton
    fun provideAnalyticsManager(generalInfo: GeneralInfo,
                                analyticsEventRepository: AnalyticsEventRepository,
                                analyticsCloudManager: AnalyticsCloudManager,
                                dateFormatter: DateFormatter,
                                timer: Timer,
                                schedulers: SchedulerProvider): AnalyticsManager {
        val numberOfEventsToSendAtOnce = 10
        return IndoorAnalyticsManager(numberOfEventsToSendAtOnce,
                generalInfo,
                analyticsEventRepository,
                analyticsCloudManager,
                dateFormatter,
                timer,
                schedulers)

    }
}