package com.estimote.indoorsdk_module.dagger.cloud_manager

import android.content.Context
import android.os.Build
import com.estimote.cloud_plugin.api.SdkInfo
import com.estimote.indoorsdk_module.BuildConfig
import com.estimote.indoorsdk_module.cloud.*
import dagger.Module
import dagger.Provides
import java.nio.charset.Charset
import java.nio.charset.CharsetEncoder

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class IndoorCloudManagerModule(private val context: Context,
                                        private val cloudCredentials: CloudCredentials) {

    @Provides
    @IndoorCloudScope
    internal fun provideIndoorCloudManager(userAgentProvider: CloudUserAgentProvider) : IndoorCloudManager {
        val headerInterceptor =  HeaderInterceptor(context, cloudCredentials, userAgentProvider)
        val api = IndoorCloudApi.build("https://cloud.estimote.com/",  headerInterceptor)
        return EstimoteIndoorCloudManager(api)
    }

    @Provides
    @IndoorCloudScope
    internal fun provideUserAgentProvider(asciiEncoder: CharsetEncoder) =
            CloudUserAgentProvider(context,  SdkInfo(BuildConfig.VERSION_NAME, "EstimoteIndoorSDK", Build.VERSION.RELEASE), asciiEncoder)

    @Provides
    @IndoorCloudScope
    internal fun provideAsciiEncoder() = Charset.forName("ASCII").newEncoder()

    @Provides
    @IndoorCloudScope
    internal fun provideCloudCredentials() : CloudCredentials = cloudCredentials



}