package com.estimote.indoorsdk_module.common.collections

import java.util.*

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class WindowBuffer<T>(private val maxSize: Int) : Buffer<T> {

    private val deque = ArrayDeque<T>(0)

    override fun get(index: Int): T {
        return deque.elementAt(index)
    }

    override fun add(item: T) {
       if (deque.size >= maxSize) deque.removeFirst()
        deque.add(item)
    }

    override fun size(): Int {
        return deque.size
    }

    override fun iterator(): Iterator<T> {
        return deque.iterator()
    }

    override fun toList(): List<T> {
        return deque.toList()
    }
}