package com.estimote.indoorsdk_module.cloud

import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers


/**
 * Basic cloud module responsible for all connections between Estimote cloud and SDK.
 *
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class EstimoteIndoorCloudManager(private val api: IndoorCloudApi) : IndoorCloudManager {

    override fun getLocation(locationId: String, callback: CloudCallback<Location>) {
        api.getLocation(locationId).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(
                        { location ->
                            callback.success(location)
                        },
                        { exception ->
                            callback.failure(EstimoteCloudException(-1, exception.message))
                        }
                )
    }

    override fun getAllLocations(callback: CloudCallback<List<Location>>) {
        api.getAllLocations()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(
                        { locations ->
                            callback.success(locations)
                        },
                        { exception ->
                            callback.failure(EstimoteCloudException(-1, exception.message))
                        }
                )
    }

}
