package com.estimote.indoorsdk_module.algorithm.position

import com.estimote.indoorsdk_module.algorithm.geometry.PlanarGeometry
import com.estimote.indoorsdk_module.cloud.LocationPosition
import com.estimote.indoorsdk_module.common.collections.Buffer
import com.estimote.indoorsdk_module.common.config.ConfigFactory
import com.estimote.indoorsdk_module.common.extensions.distanceTo

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class JumpRejectionFilter(private val configFactory: ConfigFactory,
                                   private val planarGeometry: PlanarGeometry,
                                   private val buffer: Buffer<LocationPosition>) : PositionFilter {

    private val INITIAL_POSITION = LocationPosition(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE)
    private var filteredPosition: LocationPosition = INITIAL_POSITION

    override fun filter(position: LocationPosition): LocationPosition {
        buffer.add(position)
        if (filteredPosition == INITIAL_POSITION) {
            filteredPosition = position
        } else {
            if (areAllPreviousPositionsInSimilarDistance()) filteredPosition = position
        }
        return filteredPosition
    }

    private fun areAllPreviousPositionsInSimilarDistance() : Boolean =
            buffer.none { it.distanceTo(filteredPosition) <= configFactory.getConfig().getJumpRejectionThreshold() }

}