package com.estimote.indoorsdk_module.dagger.indoor_manager

import com.estimote.indoorsdk_module.algorithm.EstimoteIndoorLocationManager
import com.estimote.indoorsdk_module.algorithm.IndoorLocationManager
import com.estimote.indoorsdk_module.algorithm.distance.RssiToDistanceCalculator
import com.estimote.indoorsdk_module.algorithm.filter.DistanceFilter
import com.estimote.indoorsdk_module.algorithm.filter.HumanWalkStatefulDistanceFilter
import com.estimote.indoorsdk_module.algorithm.filter.ScannedBeaconToLocationBeaconMapper
import com.estimote.indoorsdk_module.algorithm.position.ExponentialPositionFilter
import com.estimote.indoorsdk_module.algorithm.position.JumpRejectionFilter
import com.estimote.indoorsdk_module.algorithm.position.PositionCalculator
import com.estimote.indoorsdk_module.algorithm.sensor.MotionDetector
import com.estimote.indoorsdk_module.algorithm.sensor.StepMotionDetector
import com.estimote.indoorsdk_module.algorithm.sensor.StepMotionDetectorSubscriber
import com.estimote.indoorsdk_module.analytics.AnalyticsManager
import com.estimote.indoorsdk_module.cloud.Location
import com.estimote.indoorsdk_module.common.config.ConfigFactory
import com.estimote.indoorsdk_module.common.threading.SchedulerProvider
import com.estimote.indoorsdk_module.logging.IndoorLogger
import com.estimote.indoorsdk_module.logging.IndoorLoggerFactory
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class IndoorLocationManagerModule(private val location: Location,
                                           private val positionUpdateIntervalMillis: Long,
                                           private val loggingEnabled: Boolean) {

    @Provides
    @Singleton
    fun provideIndoorLoggerFactory() = IndoorLoggerFactory(loggingEnabled)


    @Provides
    @Singleton
    fun provideIndoorLogger(loggerFactory: IndoorLoggerFactory): IndoorLogger = loggerFactory.create()

    @Provides
    @Singleton
    fun provideEstimoteIndoorLocationManager(motionDetectorDataSubscriber: StepMotionDetectorSubscriber,
                                             scannedBeaconToLocationBeaconMapper: ScannedBeaconToLocationBeaconMapper,
                                             rssiToDistanceCalculator: RssiToDistanceCalculator,
                                             humanWalkStatefulDistanceFilter: HumanWalkStatefulDistanceFilter,
                                             beaconDistanceFilter: DistanceFilter,
                                             positionCalculator: PositionCalculator,
                                             positionFilter: ExponentialPositionFilter,
                                             jumpRejectionFilter: JumpRejectionFilter,
                                             analyticsManager: AnalyticsManager,
                                             schedulers: SchedulerProvider,
                                             configFactory: ConfigFactory,
                                             logger: IndoorLogger,
                                             sepMotionDetector: MotionDetector): IndoorLocationManager {
        return EstimoteIndoorLocationManager(
                location,
                positionUpdateIntervalMillis,
                motionDetectorDataSubscriber,
                scannedBeaconToLocationBeaconMapper,
                rssiToDistanceCalculator,
                humanWalkStatefulDistanceFilter,
                beaconDistanceFilter,
                positionCalculator,
                jumpRejectionFilter,
                positionFilter,
                analyticsManager,
                schedulers,
                configFactory,
                logger,
                sepMotionDetector)
    }

}