package com.estimote.indoorsdk_module.common.config

import java.util.concurrent.TimeUnit

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class SmallLocationMotionConfig(private val mainConfig: MainConfig) : Config {

    override fun getBeaconMeasuredPower(): Double = mainConfig.DEFAULT_BEACON_MEASURED_POWER
    override fun getBeaconMeasuredPowerCorrection(): Double = mainConfig.DEFAULT_BEACON_MEASURED_POWER_CORRECTION
    override fun getBeaconMeasuredPowerOffset(): Double = mainConfig.DEFAULT_BEACON_MEASURED_POWER_OFFSET
    override fun getRssiToDistancePropagationConstant(): Double = mainConfig.DEFAULT_RSSI_TO_DISTANCE_PROPAGATION_CONSTANT
    override fun getClosestBeaconDistanceThreshold(): Double = mainConfig.DEFAULT_SMALL_LOCATION_CLOSE_BEACON_DISTANCE_THRESHOLD_MULTIPLIER
    override fun getExponentialSmoothingConstant(): Double = mainConfig.DEFAULT_SMALL_LOCATION_POSITION_EXP_FILTER_CONSTANT_WITH_MOTION
    override fun getDistanceChangeThreshold(): Double = mainConfig.DEFAULT_SMALL_LOCATION_DISTANCE_CHANGE_THRESHOLD
    override fun getStepThreshold(): Double = mainConfig.DEFAULT_SMALL_LOCATION_LAST_STEP_SEQUENCE_DETECTION_INTERVAL
    override fun getStepSequenceNumber(): Int = mainConfig.DEFAULT_SMALL_LOCATION_SEQUENCE_STEP_NUMBER
    override fun getEpsilon(): Double = mainConfig.DEFAULT_EPSILON
    override fun getMaxDistanceToBeInsideLocation(): Double = mainConfig.MAX_DISTANCE_TO_BE_INSIDE_LOCATION
    override fun getJumpRejectionThreshold(): Double = mainConfig.JUMP_REJECTION_SMALL_LOCATION_THRESHOLD
    override fun getNormalHumanVelocity(): Double = mainConfig.NORMAL_HUMAN_VELOCITY
    override fun getHumanVelocityMaxMultiplier(): Double = mainConfig.HUMAN_VELOCITY_MAX_MULTIPLIER
    override fun getDistanceJumpEnabledThreshold(): Double = mainConfig.DISTANCE_JUMP_ENABLED_THRESHOLD
    override fun getBeaconSustainTimeSpan(): Long = mainConfig.BEACON_SUSTAIN_TIME_SPAN
    override fun getBeaconSustainTimeUnit(): TimeUnit = mainConfig.BEACON_SUSTAIN_TIME_UNIT
}