package com.estimote.indoorsdk_module.common.config

import java.util.concurrent.TimeUnit

/**
 * Configuration data with constants for filters and stuff.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal interface Config {

    fun getBeaconMeasuredPower() : Double
    fun getBeaconMeasuredPowerCorrection() : Double
    fun getBeaconMeasuredPowerOffset() : Double
    fun getRssiToDistancePropagationConstant() : Double
    fun getClosestBeaconDistanceThreshold() : Double
    fun getExponentialSmoothingConstant() : Double
    fun getDistanceChangeThreshold() : Double
    fun getStepThreshold() : Double
    fun getStepSequenceNumber(): Int
    fun getEpsilon() : Double
    fun getMaxDistanceToBeInsideLocation() : Double
    fun getJumpRejectionThreshold(): Double
    fun getNormalHumanVelocity(): Double
    fun getHumanVelocityMaxMultiplier(): Double
    fun getDistanceJumpEnabledThreshold(): Double
    fun getBeaconSustainTimeSpan(): Long
    fun getBeaconSustainTimeUnit(): TimeUnit

}