package com.estimote.indoorsdk_module.algorithm.sensor

import android.hardware.Sensor
import android.hardware.SensorEvent
import android.hardware.SensorEventListener
import android.hardware.SensorManager
import io.reactivex.Observable


/**
 * Makes sensor layer much more observable :)
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class ObservableSensors(private val sensorManager: SensorManager) {

    fun hasSensor(sensorType: Int): Boolean {
        return sensorManager.getDefaultSensor(sensorType) != null
    }

    fun observeSensorChanges(sensorType: Int, sensorDelay: Int): Observable<EstimoteSensorEvent> {
        require(hasSensor(sensorType), { "Sensor with id $sensorType is not available on this device" })
        val sensor = sensorManager.getDefaultSensor(sensorType)
        return Observable.create<EstimoteSensorEvent> { subscriber ->
            val listener = object : SensorEventListener {
                override fun onSensorChanged(event: SensorEvent) {
                    subscriber.onNext(EstimoteSensorEvent(event))
                }

                override fun onAccuracyChanged(sensor: Sensor, accuracy: Int) {
                    subscriber.onNext(EstimoteSensorEvent(sensor = sensor, accuracy = accuracy))
                }
            }
            sensorManager.registerListener(listener, sensor, sensorDelay)
            subscriber.setCancellable { sensorManager.unregisterListener(listener) }
        }

    }

}