package com.estimote.indoorsdk_module.dagger.indoor_manager

import com.estimote.indoorsdk_module.common.time.DateFormatter
import com.estimote.indoorsdk_module.common.time.SimpleDateFormatter
import com.estimote.indoorsdk_module.common.time.SystemTimer
import com.estimote.indoorsdk_module.common.time.Timer
import dagger.Module
import dagger.Provides
import java.util.*
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class DateAndTimeModule {

    @Provides
    @Singleton
    fun provideTimer(): Timer = SystemTimer()

    @Provides
    @Singleton
    fun provideLocale() : Locale = Locale.getDefault()

    @Provides
    @Singleton
    fun provideDateFormatter(locale: Locale) : DateFormatter =  SimpleDateFormatter(locale)

}