package com.estimote.indoorsdk_module.dagger.indoor_manager

import com.estimote.indoorsdk_module.algorithm.sensor.MotionDetector
import com.estimote.indoorsdk_module.cloud.Location
import com.estimote.indoorsdk_module.common.config.ConfigFactory
import com.estimote.indoorsdk_module.common.config.DefaultConfigFactory
import com.estimote.indoorsdk_module.common.config.MainConfig
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class ConfigurationModule(private val location: Location) {

    @Provides
    @Singleton
    fun provideMainConfig(): MainConfig = MainConfig()

    @Provides
    @Singleton
    fun provideConfigFactory(mainConfig: MainConfig,
                             motionDetector: MotionDetector): ConfigFactory {
        return DefaultConfigFactory(mainConfig, motionDetector, location.isSmall(mainConfig))
    }

    private fun Location.isSmall(config: MainConfig): Boolean {
        return this.beacons.size <= config.DEFAULT_MAX_BEACON_COUNT_FOR_SMALL_LOCATION
    }

}