package com.estimote.indoorsdk_module.cloud

import android.content.Context
import com.estimote.cloud_plugin.api.SdkInfo
import java.nio.charset.CharsetEncoder

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class CloudUserAgentProvider(private val context: Context,
                                      private val sdkInfo: SdkInfo,
                                      private val asciiEncoder: CharsetEncoder) {

    // TODO: Delete "like EstimoteSDK/4.12.0" phrase when it is repaired on cloud side
    val userAgent: String by lazy { "${getApplicationName()} (${getDeviceName()}; Android ${sdkInfo.androidOsVersion}) ${sdkInfo.sdkName}/${sdkInfo.sdkVersionName} like EstimoteSDK/4.12.0" }

    private fun getDeviceName(): String = if (android.os.Build.MODEL.startsWith(android.os.Build.MANUFACTURER)) {
        android.os.Build.MODEL
    } else {
        android.os.Build.MANUFACTURER + " " + android.os.Build.MODEL
    }

    private fun getApplicationName(): String {
        if (context.applicationInfo.labelRes != 0) {
            val name = context.getString(context.applicationInfo.labelRes)
            if (asciiEncoder.canEncode(name)) {
                return name
            }
        }
        return context.packageName
    }

}