/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.indoorsdk_module.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.Keep;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.estimote.indoorsdk_module.R;
import com.estimote.indoorsdk_module.cloud.Location;
import com.estimote.indoorsdk_module.cloud.LocationBeacon;
import com.estimote.indoorsdk_module.cloud.LocationBeaconColor;
import com.estimote.indoorsdk_module.cloud.LocationBeaconData;
import com.estimote.indoorsdk_module.cloud.LocationPosition;
import com.estimote.indoorsdk_module.cloud.LocationWall;
import com.estimote.indoorsdk_module.view.b;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0015\b\u0007\u0018\u00002\u00020\u0001:\u0001OB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\fH\u0002J\b\u0010/\u001a\u00020\rH\u0002J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002J\b\u00101\u001a\u00020\rH\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00107\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00108\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00109\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0019H\u0002J\u0006\u0010=\u001a\u000203J\u0010\u0010>\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J\u0010\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020;H\u0002J\u0010\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020;H\u0002J\u0010\u0010C\u001a\u0002032\u0006\u0010D\u001a\u00020\u0013H\u0002J\u000e\u0010E\u001a\u0002032\u0006\u0010F\u001a\u00020\u000fJ\u0014\u0010G\u001a\u0002032\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010I\u001a\u0002032\u0006\u0010J\u001a\u00020\u0017J\b\u0010K\u001a\u000203H\u0002J\u000e\u0010L\u001a\u0002032\u0006\u0010M\u001a\u00020\u0013J\f\u0010N\u001a\u00020%*\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/estimote/indoorsdk_module/view/IndoorLocationView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mBeaconBitmapScale", "", "mBeaconColorToBitmapMapping", "", "Lcom/estimote/indoorsdk_module/cloud/LocationBeaconColor;", "Landroid/graphics/Bitmap;", "mCustomPoint", "Landroid/graphics/Paint;", "mCustomPointStrokeWidth", "mCustomPoints", "", "Lcom/estimote/indoorsdk_module/cloud/LocationPosition;", "mDrawParams", "Lcom/estimote/indoorsdk_module/view/DrawParams;", "mLocation", "Lcom/estimote/indoorsdk_module/cloud/Location;", "mLocationPadding", "", "mLocationPath", "Landroid/graphics/Path;", "mMatrix", "Landroid/graphics/Matrix;", "mNearbyBeaconPaint", "mNearbyBeaconRadius", "mNearbyBeaconTextPaint", "mNearbyBeacons", "Lcom/estimote/indoorsdk_module/algorithm/model/BeaconWithDistance;", "mNearbyBeaconsPath", "mPosition", "Lcom/estimote/indoorsdk_module/view/IndoorLocationView$ViewLocationPosition;", "mPositionAnimationDuration", "", "mPositionAnimator", "Lcom/estimote/indoorsdk_module/view/animation/PositionAnimator;", "mPositionBitmap", "mWallPaint", "mWallStrokeWidth", "createBeaconColorBitmap", "color", "createBeaconUnknownColorBitmap", "createColorToBitmapMapping", "createPositionBitmap", "drawBeacons", "", "canvas", "Landroid/graphics/Canvas;", "drawCustomPoints", "drawLocation", "drawNearbyBeacons", "drawPosition", "findScaleForViewOrientation", "", "thresholdPercentage", "hidePosition", "onDraw", "realXtoViewX", "x", "realYtoViewY", "y", "redrawNewPosition", "position", "setBorderPaint", "paint", "setCustomPoints", "points", "setLocation", "location", "updateDrawParams", "updatePosition", "newPosition", "convertToViewPosition", "ViewLocationPosition", "indoor-sdk-module_release"})
@Keep
public final class IndoorLocationView
extends View {
    private Paint mWallPaint;
    private Paint mCustomPoint;
    private Paint mNearbyBeaconPaint;
    private Paint mNearbyBeaconTextPaint;
    private float mBeaconBitmapScale;
    private float mWallStrokeWidth;
    private float mCustomPointStrokeWidth;
    private float mNearbyBeaconRadius;
    private int mLocationPadding;
    private long mPositionAnimationDuration;
    private Location mLocation;
    private a mPosition;
    private List<com.estimote.indoorsdk_module.algorithm.d.a> mNearbyBeacons;
    private List<LocationPosition> mCustomPoints;
    private final Path mLocationPath;
    private final Path mNearbyBeaconsPath;
    private final Map<LocationBeaconColor, Bitmap> mBeaconColorToBitmapMapping;
    private final Bitmap mPositionBitmap;
    private final com.estimote.indoorsdk_module.view.a mDrawParams;
    private final Matrix mMatrix;
    private final com.estimote.indoorsdk_module.view.a.a mPositionAnimator;

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.updateDrawParams();
        this.drawLocation(canvas);
        this.drawBeacons(canvas);
        this.drawCustomPoints(canvas);
        this.drawNearbyBeacons(canvas);
        this.drawPosition(canvas);
    }

    private final Bitmap createPositionBitmap() {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)b.a.b());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeReso\u2026ry.getPositionDrawable())");
        return bitmap;
    }

    private final Map<LocationBeaconColor, Bitmap> createColorToBitmapMapping() {
        Object[] objectArray = (Object[])LocationBeaconColor.values();
        int n2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)objectArray.length), (int)16);
        Object[] objectArray2 = objectArray;
        Map map = new LinkedHashMap(n2);
        for (Object object : objectArray2) {
            Map map2 = map;
            LocationBeaconColor locationBeaconColor = (LocationBeaconColor)((Object)object);
            Pair pair = TuplesKt.to((Object)((Object)locationBeaconColor), (Object)this.createBeaconColorBitmap(locationBeaconColor));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return map;
    }

    private final Bitmap createBeaconColorBitmap(LocationBeaconColor locationBeaconColor) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)b.a.a(locationBeaconColor));
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeReso\u2026getBeaconDrawable(color))");
        return bitmap;
    }

    private final Bitmap createBeaconUnknownColorBitmap() {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)b.a.a());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeReso\u2026ownColorBeaconDrawable())");
        return bitmap;
    }

    private final void drawLocation(Canvas canvas) {
        this.mLocationPath.reset();
        Iterable iterable = this.mLocation.getWalls();
        for (Object t2 : iterable) {
            LocationWall locationWall = (LocationWall)t2;
            this.mLocationPath.moveTo(this.realXtoViewX(locationWall.getX1()), this.realYtoViewY(locationWall.getY1()));
            this.mLocationPath.lineTo(this.realXtoViewX(locationWall.getX2()), this.realYtoViewY(locationWall.getY2()));
        }
        canvas.drawPath(this.mLocationPath, this.mWallPaint);
    }

    private final void drawBeacons(Canvas canvas) {
        Iterable iterable = this.mLocation.getBeacons();
        for (Object t2 : iterable) {
            LocationBeacon locationBeacon = (LocationBeacon)t2;
            LocationBeaconData locationBeaconData = locationBeacon.component1();
            LocationPosition locationPosition = locationBeacon.component2();
            this.mMatrix.reset();
            Bitmap bitmap = this.mBeaconColorToBitmapMapping.get((Object)locationBeaconData.getColor());
            if (bitmap == null) {
                bitmap = this.createBeaconUnknownColorBitmap();
            }
            Bitmap bitmap2 = bitmap;
            int n2 = bitmap2.getWidth();
            int n3 = bitmap2.getHeight();
            float f2 = this.realXtoViewX(locationPosition.getX());
            float f3 = this.realYtoViewY(locationPosition.getY());
            this.mMatrix.setTranslate(f2 - (float)n2 / 2.0f, f3 - (float)n3 / 2.0f);
            this.mMatrix.postScale(this.mBeaconBitmapScale, this.mBeaconBitmapScale, f2, f3);
            this.mMatrix.postRotate((float)locationPosition.getOrientation(), f2, f3);
            canvas.drawBitmap(bitmap2, this.mMatrix, null);
        }
    }

    private final void drawNearbyBeacons(Canvas canvas) {
        com.estimote.indoorsdk_module.algorithm.d.a a2;
        this.mNearbyBeaconsPath.reset();
        Iterable iterable = this.mNearbyBeacons;
        for (Object t2 : iterable) {
            a2 = (com.estimote.indoorsdk_module.algorithm.d.a)t2;
            this.mNearbyBeaconsPath.addCircle(this.realXtoViewX(a2.a().getPosition().getX()), this.realYtoViewY(a2.a().getPosition().getY()), this.mNearbyBeaconRadius, Path.Direction.CW);
        }
        canvas.drawPath(this.mNearbyBeaconsPath, this.mNearbyBeaconPaint);
        iterable = this.mNearbyBeacons;
        for (Object t2 : iterable) {
            a2 = (com.estimote.indoorsdk_module.algorithm.d.a)t2;
            canvas.drawText(String.valueOf((int)a2.b()), this.realXtoViewX(a2.a().getPosition().getX()), this.realYtoViewY(a2.a().getPosition().getY()), this.mNearbyBeaconTextPaint);
        }
    }

    private final void drawPosition(Canvas canvas) {
        if (!this.mPosition.d()) {
            this.mMatrix.reset();
            float f2 = this.mPositionBitmap.getWidth();
            float f3 = this.mPositionBitmap.getHeight();
            float f4 = this.realXtoViewX(this.mPosition.a());
            float f5 = this.realYtoViewY(this.mPosition.b());
            this.mMatrix.setTranslate(f4 - f2 / 2.0f, f5 - f3 / 2.0f);
            this.mMatrix.postRotate((float)this.mPosition.c(), f4, f5);
            canvas.drawBitmap(this.mPositionBitmap, this.mMatrix, null);
        }
    }

    private final void drawCustomPoints(Canvas canvas) {
        Iterable iterable = this.mCustomPoints;
        for (Object t2 : iterable) {
            LocationPosition locationPosition = (LocationPosition)t2;
            canvas.drawPoint(this.realXtoViewX(locationPosition.getX()), this.realYtoViewY(locationPosition.getY()), this.mCustomPoint);
        }
    }

    private final void updateDrawParams() {
        this.mDrawParams.a(this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight()));
        this.mDrawParams.b(this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom()));
        this.mDrawParams.a((double)this.getPaddingLeft() + (double)this.mDrawParams.a() / 2.0);
        this.mDrawParams.b((double)this.getPaddingTop() + (double)this.mDrawParams.b() / 2.0);
        this.mDrawParams.c(this.findScaleForViewOrientation(this.mLocationPadding));
    }

    private final double findScaleForViewOrientation(int n2) {
        int n3 = this.mDrawParams.a() * n2 / 100;
        double d2 = (double)(this.mDrawParams.a() - n3) / this.mDrawParams.f();
        int n4 = this.mDrawParams.b() * n2 / 100;
        double d3 = (double)(this.mDrawParams.b() - n4) / this.mDrawParams.g();
        return Math.min(d2, d3);
    }

    private final float realXtoViewX(double d2) {
        double d3 = this.mDrawParams.c() - this.mDrawParams.f() / (double)2 * this.mDrawParams.e();
        return (float)(d2 * this.mDrawParams.e() + d3);
    }

    private final float realYtoViewY(double d2) {
        double d3 = this.mDrawParams.d() - this.mDrawParams.g() / (double)2 * this.mDrawParams.e();
        return (float)((double)this.mDrawParams.b() - (d2 * this.mDrawParams.e() + d3));
    }

    private final a convertToViewPosition(@NotNull LocationPosition locationPosition) {
        return new a(locationPosition.getX(), locationPosition.getY(), locationPosition.getOrientation(), false, 8, null);
    }

    public final void setLocation(@NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.mLocation = com.estimote.indoorsdk_module.common.c.a.a(location);
        this.mDrawParams.d(Math.abs(com.estimote.indoorsdk_module.common.c.a.b(location) - com.estimote.indoorsdk_module.common.c.a.d(location)));
        this.mDrawParams.e(Math.abs(com.estimote.indoorsdk_module.common.c.a.c(location) - com.estimote.indoorsdk_module.common.c.a.e(location)));
        this.invalidate();
    }

    public final void updatePosition(final @NotNull LocationPosition locationPosition) {
        Intrinsics.checkParameterIsNotNull((Object)locationPosition, (String)"newPosition");
        this.postOnAnimation(new Runnable(){

            @Override
            public final void run() {
                if (mPosition.d()) {
                    this.redrawNewPosition(locationPosition);
                } else {
                    mPositionAnimator.a(mPosition, this.convertToViewPosition(locationPosition), (Function1<? super LocationPosition, Unit>)((Function1)new Function1<LocationPosition, Unit>(){

                        public /* synthetic */ Object invoke(Object object) {
                            this.a((LocationPosition)object);
                            return Unit.INSTANCE;
                        }

                        public final void a(@NotNull LocationPosition locationPosition) {
                            Intrinsics.checkParameterIsNotNull((Object)locationPosition, (String)"it");
                            this.redrawNewPosition(locationPosition);
                        }
                    }));
                }
            }
        });
    }

    private final void redrawNewPosition(LocationPosition locationPosition) {
        this.mPosition = this.convertToViewPosition(locationPosition);
        this.invalidate();
    }

    public final void setCustomPoints(@NotNull List<LocationPosition> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"points");
        this.mCustomPoints = list;
        this.postInvalidate();
    }

    public final void setBorderPaint(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.mWallPaint = paint;
    }

    public final void hidePosition() {
        this.mPosition = new a(0.0, 0.0, 0.0, true, 7, null);
    }

    public IndoorLocationView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mWallPaint = new Paint(1);
        this.mCustomPoint = new Paint(1);
        this.mNearbyBeaconPaint = new Paint(1);
        this.mNearbyBeaconTextPaint = new Paint(1);
        this.mBeaconBitmapScale = 0.3f;
        this.mWallStrokeWidth = 5.0f;
        this.mCustomPointStrokeWidth = 20.0f;
        this.mNearbyBeaconRadius = 40.0f;
        this.mLocationPadding = 10;
        this.mPositionAnimationDuration = 800L;
        this.mLocation = new Location(null, null, false, null, 0.0, null, null, null, 255, null);
        this.mPosition = new a(0.0, 0.0, 0.0, true, 7, null);
        this.mNearbyBeacons = CollectionsKt.emptyList();
        this.mCustomPoints = CollectionsKt.emptyList();
        this.mLocationPath = new Path();
        this.mNearbyBeaconsPath = new Path();
        this.mBeaconColorToBitmapMapping = this.createColorToBitmapMapping();
        this.mPositionBitmap = this.createPositionBitmap();
        this.mDrawParams = new com.estimote.indoorsdk_module.view.a(0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 127, null);
        this.mMatrix = new Matrix();
        this.mPositionAnimator = new com.estimote.indoorsdk_module.view.a.a(this.mPositionAnimationDuration, (Interpolator)new LinearInterpolator(), new ValueAnimator());
        this.mWallPaint.setStyle(Paint.Style.STROKE);
        this.mWallPaint.setColor(this.getContext().getResources().getColor(R.color.colorPrimary));
        this.mWallPaint.setStrokeWidth(this.mWallStrokeWidth);
        this.mCustomPoint.setStyle(Paint.Style.FILL);
        this.mCustomPoint.setColor(this.getContext().getResources().getColor(R.color.colorAccent));
        this.mCustomPoint.setStrokeWidth(this.mCustomPointStrokeWidth);
        this.mNearbyBeaconPaint.setStyle(Paint.Style.FILL);
        this.mNearbyBeaconPaint.setColor(this.getContext().getResources().getColor(R.color.colorNearbyBeaconCircle));
        this.mNearbyBeaconPaint.setStrokeWidth(5.0f);
        this.mNearbyBeaconTextPaint.setColor(this.getContext().getResources().getColor(R.color.colorText));
        this.mNearbyBeaconTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mNearbyBeaconTextPaint.setTextSize(32.0f);
    }

    public IndoorLocationView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributeSet, (String)"attrs");
        super(context, attributeSet);
        this.mWallPaint = new Paint(1);
        this.mCustomPoint = new Paint(1);
        this.mNearbyBeaconPaint = new Paint(1);
        this.mNearbyBeaconTextPaint = new Paint(1);
        this.mBeaconBitmapScale = 0.3f;
        this.mWallStrokeWidth = 5.0f;
        this.mCustomPointStrokeWidth = 20.0f;
        this.mNearbyBeaconRadius = 40.0f;
        this.mLocationPadding = 10;
        this.mPositionAnimationDuration = 800L;
        this.mLocation = new Location(null, null, false, null, 0.0, null, null, null, 255, null);
        this.mPosition = new a(0.0, 0.0, 0.0, true, 7, null);
        this.mNearbyBeacons = CollectionsKt.emptyList();
        this.mCustomPoints = CollectionsKt.emptyList();
        this.mLocationPath = new Path();
        this.mNearbyBeaconsPath = new Path();
        this.mBeaconColorToBitmapMapping = this.createColorToBitmapMapping();
        this.mPositionBitmap = this.createPositionBitmap();
        this.mDrawParams = new com.estimote.indoorsdk_module.view.a(0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 127, null);
        this.mMatrix = new Matrix();
        this.mPositionAnimator = new com.estimote.indoorsdk_module.view.a.a(this.mPositionAnimationDuration, (Interpolator)new LinearInterpolator(), new ValueAnimator());
        this.mWallPaint.setStyle(Paint.Style.STROKE);
        this.mWallPaint.setColor(this.getContext().getResources().getColor(R.color.colorPrimary));
        this.mWallPaint.setStrokeWidth(this.mWallStrokeWidth);
        this.mCustomPoint.setStyle(Paint.Style.FILL);
        this.mCustomPoint.setColor(this.getContext().getResources().getColor(R.color.colorAccent));
        this.mCustomPoint.setStrokeWidth(this.mCustomPointStrokeWidth);
        this.mNearbyBeaconPaint.setStyle(Paint.Style.FILL);
        this.mNearbyBeaconPaint.setColor(this.getContext().getResources().getColor(R.color.colorNearbyBeaconCircle));
        this.mNearbyBeaconPaint.setStrokeWidth(5.0f);
        this.mNearbyBeaconTextPaint.setColor(this.getContext().getResources().getColor(R.color.colorText));
        this.mNearbyBeaconTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mNearbyBeaconTextPaint.setTextSize(32.0f);
    }

    public static final /* synthetic */ void access$setMPosition$p(IndoorLocationView indoorLocationView, @NotNull a a2) {
        indoorLocationView.mPosition = a2;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/estimote/indoorsdk_module/view/IndoorLocationView$ViewLocationPosition;", "", "x", "", "y", "orientation", "isHidden", "", "(DDDZ)V", "()Z", "getOrientation", "()D", "getX", "getY", "indoor-sdk-module_release"})
    public static final class a {
        private final double a;
        private final double b;
        private final double c;
        private final boolean d;

        public final double a() {
            return this.a;
        }

        public final double b() {
            return this.b;
        }

        public final double c() {
            return this.c;
        }

        public final boolean d() {
            return this.d;
        }

        public a(double d2, double d3, double d4, boolean bl) {
            this.a = d2;
            this.b = d3;
            this.c = d4;
            this.d = bl;
        }

        public /* synthetic */ a(double d2, double d3, double d4, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                d2 = 0.0;
            }
            if ((n2 & 2) != 0) {
                d3 = 0.0;
            }
            if ((n2 & 4) != 0) {
                d4 = 0.0;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(d2, d3, d4, bl);
        }

        public a() {
            this(0.0, 0.0, 0.0, false, 15, null);
        }
    }
}

