package com.estimote.indoorsdk_module.dagger.indoor_manager

import com.estimote.indoorsdk_module.algorithm.geometry.PlanarGeometry
import com.estimote.indoorsdk_module.algorithm.voronoi.LocationPointTransformer
import com.estimote.indoorsdk_module.algorithm.voronoi.VoronoiSplitter
import com.estimote.indoorsdk_module.common.config.ConfigFactory
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */

@Module
internal class GeometryModule {

    @Provides
    @Singleton
    fun providePlanarGeometry() : PlanarGeometry = PlanarGeometry()

    @Provides
    @Singleton
    fun provideLocationPointTransformer(planarGeometry: PlanarGeometry) : LocationPointTransformer = LocationPointTransformer(planarGeometry)

    @Provides
    @Singleton
    fun provideVornoiSplitter(configFactory: ConfigFactory,
                              planarGeometry: PlanarGeometry,
                              locationPointTransformer: LocationPointTransformer) : VoronoiSplitter = VoronoiSplitter(configFactory, planarGeometry, locationPointTransformer)



}