package com.estimote.indoorsdk_module.dagger.indoor_manager

import com.estimote.indoorsdk_module.algorithm.distance.RssiToDistanceCalculator
import com.estimote.indoorsdk_module.algorithm.distance.HumanWalkStatefulDistanceCalculator
import com.estimote.indoorsdk_module.algorithm.distance.SimpleRssiToDistanceCalculator
import com.estimote.indoorsdk_module.algorithm.distance.StatefulDistanceCalculator
import com.estimote.indoorsdk_module.algorithm.filter.*
import com.estimote.indoorsdk_module.algorithm.geometry.PlanarGeometry
import com.estimote.indoorsdk_module.algorithm.position.*
import com.estimote.indoorsdk_module.algorithm.voronoi.VoronoiSplitter
import com.estimote.indoorsdk_module.cloud.Location
import com.estimote.indoorsdk_module.cloud.LocationPosition
import com.estimote.indoorsdk_module.common.collections.WindowBuffer
import com.estimote.indoorsdk_module.common.config.ConfigFactory
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class FiltersModule(private val location: Location) {

    @Provides
    @Singleton
    fun provideBeaconMapper(): ScannedBeaconToLocationBeaconMapper {
        return ScannedBeaconToLocationBeaconMapper()
    }

    @Provides
    @Singleton
    fun provideDistanceCalculator(configFactory: ConfigFactory): RssiToDistanceCalculator {
        return SimpleRssiToDistanceCalculator(configFactory)
    }

    @Provides
    @Singleton
    fun provideHumanWalkStatefulDistanceCalculator(configFactory: ConfigFactory): StatefulDistanceCalculator =
            HumanWalkStatefulDistanceCalculator(configFactory)

    @Provides
    @Singleton
    fun provideStatefulHumanWalkDistanceFilter(statefulDistanceCalculator: StatefulDistanceCalculator): HumanWalkStatefulDistanceFilter =
            HumanWalkStatefulDistanceFilter(statefulDistanceCalculator)


    @Provides
    @Singleton
    fun provideDistanceFilter(configFactory: ConfigFactory): DistanceFilter = ClosestBeaconDistanceFilter(configFactory)

    @Provides
    @Singleton
    fun providePositionCalculator(voronoiSplitter: VoronoiSplitter): PositionCalculator {
        val beaconsVoronoiCenterMap = voronoiSplitter.getVoronoiCentersForBeaconsInLocation(location)
        return MeanPositionCalculator(beaconsVoronoiCenterMap)
    }

    @Provides
    @Singleton
    fun providePositionSmoothingFilter(configFactory: ConfigFactory,
                                       planarGeometry: PlanarGeometry): ExponentialPositionFilter = ExponentialPositionFilter(configFactory, planarGeometry)


    @Provides
    @Singleton
    fun provideJumpRejectionFilter(configFactory: ConfigFactory,
                                   planarGeometry: PlanarGeometry): JumpRejectionFilter {
        val windowSize = 2
        return JumpRejectionFilter(configFactory, planarGeometry, WindowBuffer<LocationPosition>(windowSize))
    }

}

