package com.estimote.indoorsdk_module.common.helpers

import android.support.annotation.Keep
import com.estimote.indoorsdk_module.algorithm.IndoorLocationManager
import com.estimote.indoorsdk_module.algorithm.OnPositionUpdateListener
import com.estimote.indoorsdk_module.cloud.LocationPosition
import com.estimote.indoorsdk_module.view.IndoorLocationView

/**
 * Helper for setting up connections between [IndoorLocationManager] and [IndoorLocationView].
 * It hooks necessary listeners for you, so the whole system will provide you with complete position display.
 * If you need to do some custom setup, you would need to setup all listeners by yourself.
 * The flow is rather simple:
 * 1. IndoorLocationManager converts scanned beacons data to (x,y) coordinates
 * 2. IndoorLocationView draws (x,y) on your screen.
 * 
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Keep
class EstimoteIndoorHelper {

    @Keep
    companion object {
        fun setupIndoorPositioning(indoorLocationManager:IndoorLocationManager, indoorLocationView: IndoorLocationView) {
            indoorLocationManager.setOnPositionUpdateListener(object : OnPositionUpdateListener {
                override fun onPositionUpdate(locationPosition: LocationPosition) {
                    indoorLocationView.updatePosition(locationPosition)
                }

                override fun onPositionOutsideLocation() {
                    indoorLocationView.hidePosition()
                }
            })
        }


    }

}