package com.estimote.indoorsdk_module.common.config

import com.estimote.indoorsdk_module.algorithm.sensor.MotionDetector

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class DefaultConfigFactory(mainConfig: MainConfig,
                                    private val motionDetector: MotionDetector,
                                    private val isLocationSmall: Boolean) : ConfigFactory {

    // with motion
    val motionConfig = MotionConfig(mainConfig)
    val smallLocationMotionConfig = SmallLocationMotionConfig(mainConfig)

    // without motion
    val noMotionConfig = NoMotionConfig(mainConfig)
    val smallLocationNoMotionConfig = SmallLocationNoMotionConfig(mainConfig)

    override fun getConfig(): Config {
        if (isLocationSmall) {
            return configForSmallLocation()
        } else {
            return configForLargeLocation()
        }
    }

    private fun configForSmallLocation(): Config {
        if (motionDetector.isInMotion()) {
            return smallLocationMotionConfig
        } else {
            return smallLocationNoMotionConfig
        }
    }


    private fun configForLargeLocation(): Config {
        if (motionDetector.isInMotion()) {
            return motionConfig
        } else {
            return noMotionConfig
        }
    }

}