package com.estimote.indoorsdk_module.algorithm.sensor

import com.estimote.android_ketchup.rx_goodness.rollingBuffer
import com.estimote.indoorsdk_module.common.config.Config
import io.reactivex.disposables.Disposable
import io.reactivex.subjects.PublishSubject
import java.util.concurrent.TimeUnit

/**
 *
 * Detects user motion from steps.
 * User is assumed to be in motion, when a sequence of X steps occur.
 * User is assumed not to be in motion, when last step occurred later then threshold.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */

internal class StepMotionDetector(private val config: Config) : MotionDetector {
    private var isInMotion = false
    private var disposable: Disposable? = null

    private val eventSubject = PublishSubject.create<EstimoteSensorEvent>()

    override fun start() {
        disposable = eventSubject
                .rollingBuffer((config.getStepSequenceNumber() * config.getStepThreshold().toMillis()).toLong(), TimeUnit.MILLISECONDS)
                .map { it.size >= config.getStepSequenceNumber() }
                .retry()
                .subscribe { isInMotion = it }
    }

    override fun stop() {
        disposable?.dispose()
    }

    override fun onEvent(event: EstimoteSensorEvent) {
        eventSubject.onNext(event)
    }

    override fun isInMotion() = isInMotion

    private fun Double.toMillis() = this * 1000


}