package com.estimote.indoorsdk_module.algorithm.sensor

import android.hardware.Sensor
import android.hardware.SensorEvent
import java.util.concurrent.TimeUnit

/**
 * Wrapper class for sensor events.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal data class EstimoteSensorEvent (val values: List<Float> = emptyList(),
                                val sensor: Sensor? = null,
                                val accuracy: Int = 0,
                                val timestampMillis: Long = 0,
                                val containsSensorData: Boolean = false){
    constructor(event: SensorEvent) : this(
            event.values.asList(),
            event.sensor,
            event.accuracy,
            TimeUnit.NANOSECONDS.toMillis(event.timestamp),
            true)
}