package com.estimote.indoorsdk_module.view

import com.estimote.indoorsdk_module.R
import com.estimote.indoorsdk_module.cloud.LocationBeaconColor

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class EstimoteDrawableFactory {

    companion object {
        fun getBeaconDrawable(beaconColor: LocationBeaconColor) = when (beaconColor) {
            LocationBeaconColor.LEMON_TART -> R.drawable.beacon_lemon_small
            LocationBeaconColor.CANDY_FLOSS -> R.drawable.beacon_candy_small
            LocationBeaconColor.SWEET_BEETROOT -> R.drawable.beacon_beetroot_small
            LocationBeaconColor.WHITE -> R.drawable.beacon_white_small
            LocationBeaconColor.BLUEBERRY_PIE -> R.drawable.beacon_blueberry_small
            LocationBeaconColor.MINT_COCKTAIL -> R.drawable.beacon_mint_small
            LocationBeaconColor.TRANSPARENT -> R.drawable.beacon_transparent_small
            LocationBeaconColor.BLACK -> R.drawable.beacon_black_small
            LocationBeaconColor.ICY_MARSHMALLOW -> R.drawable.beacon_icy_small
            LocationBeaconColor.GREY -> R.drawable.beacon_grey_small
            else -> getUnknownColorBeaconDrawable()
        }

        fun getUnknownColorBeaconDrawable() = R.drawable.beacon_candy_small

        fun getPositionDrawable() = R.drawable.avatar

    }


}