package com.estimote.indoorsdk_module.common.config

import java.util.concurrent.TimeUnit

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class MainConfig {

    val DEFAULT_EPSILON = 0.000001

    // calculating rssi -> distance
    val DEFAULT_BEACON_MEASURED_POWER = -56.0
    val DEFAULT_BEACON_MEASURED_POWER_CORRECTION = -0.58
    val DEFAULT_BEACON_MEASURED_POWER_OFFSET = 0.0
    val DEFAULT_RSSI_TO_DISTANCE_PROPAGATION_CONSTANT = -8.2

    // with motion
    val DEFAULT_POSITION_EXP_FILTER_CONSTANT_WITH_MOTION = 0.6
    val DEFAULT_SMALL_LOCATION_POSITION_EXP_FILTER_CONSTANT_WITH_MOTION = 0.6

    // no motion
    val DEFAULT_POSITION_EXP_FILTER_CONSTANT_WITHOUT_MOTION = 0.96
    val DEFAULT_SMALL_LOCATION_POSITION_EXP_FILTER_CONSTANT_WITHOUT_MOTION = 0.9

    // rest
    val DEFAULT_DISTANCE_CHANGE_THRESHOLD = 1.1
    val DEFAULT_SMALL_LOCATION_DISTANCE_CHANGE_THRESHOLD = 0.0

    // steps
    val DEFAULT_LAST_STEP_SEQUENCE_DETECTION_INTERVAL = 5.5
    val DEFAULT_SMALL_LOCATION_LAST_STEP_SEQUENCE_DETECTION_INTERVAL = 5.5
    val DEFAULT_SEQUENCE_STEP_NUMBER = 2
    val DEFAULT_SMALL_LOCATION_SEQUENCE_STEP_NUMBER = 1
    val DEFAULT_STEPS_SEQUENCE_DETECTION_MIN_INTERVAL = 0.4
    val DEFAULT_SMALL_LOCATION_STEPS_SEQUENCE_DETECTION_MIN_INTERVAL = 0.4
    val DEFAULT_STEPS_SEQUENCE_DETECTION_MAX_INTERVAL = 0.9
    val DEFAULT_SMALL_LOCATION_STEPS_SEQUENCE_DETECTION_MAX_INTERVAL = 0.9

    // closest beacons
    val DEFAULT_CLOSE_BEACON_DISTANCE_THRESHOLD_MULTIPLIER = 1.9
    val DEFAULT_SMALL_LOCATION_CLOSE_BEACON_DISTANCE_THRESHOLD_MULTIPLIER = 2.4

    // small location
    val DEFAULT_MAX_BEACON_COUNT_FOR_SMALL_LOCATION = 8

    // inside location checking
    val MAX_DISTANCE_TO_BE_INSIDE_LOCATION = 30.0

    // jump rejection
    val JUMP_REJECTION_THRESHOLD = 3.0

    // human walk filtering
    val HUMAN_VELOCITY_MAX_MULTIPLIER = 3.0
    val NORMAL_HUMAN_VELOCITY = 1.22
    val DISTANCE_JUMP_ENABLED_THRESHOLD = 15.0

    // beacon sustain
    val BEACON_SUSTAIN_TIME_SPAN = 5L
    val BEACON_SUSTAIN_TIME_UNIT = TimeUnit.SECONDS
}