package com.estimote.indoorsdk_module.cloud.analytics

import com.estimote.indoorsdk_module.cloud.AnalyticsEventHeader
import com.estimote.indoorsdk_module.cloud.IndoorCloudApi
import com.estimote.indoorsdk_module.cloud.PositioningParameters
import io.reactivex.Observable
import io.reactivex.schedulers.Schedulers

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class AnalyticsIndoorCloudManager(private val api: IndoorCloudApi) : AnalyticsCloudManager {

    override fun getPositioningParameters(analyticsEventHeader: AnalyticsEventHeader): Observable<PositioningParameters> {
        return api.getPositioningParameters(analyticsEventHeader).subscribeOn(Schedulers.io())
    }

}