package com.estimote.indoorsdk_module.cloud

import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import io.reactivex.Observable
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal interface IndoorCloudApi {

    @GET("v1/indoor/locations/{id}")
    fun getLocation(@Path("id") id : String): Observable<Location>

    @GET("v1/indoor/locations/")
    fun getAllLocations(): Observable<List<Location>>

    @POST("v1/indoor/positioning_parameters/")
    fun getPositioningParameters(@Body analyticsEventHeader: AnalyticsEventHeader): Observable<PositioningParameters>

    companion object {
        fun build(endpoint: String,  vararg interceptors: Interceptor) : IndoorCloudApi {
                val clientBuilder = OkHttpClient().newBuilder()
                interceptors.forEach { clientBuilder.addInterceptor(it) }
                val retrofit = Retrofit.Builder()
                        .baseUrl(endpoint)
                        .addConverterFactory(GsonConverterFactory.create())
                        .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                        .client(clientBuilder.build())
                        .build()
                return retrofit.create(IndoorCloudApi::class.java)
        }
    }

}