package com.estimote.indoorsdk_module.cloud

import android.content.Context
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import okhttp3.Interceptor
import okhttp3.Request

/**
 * Adds additional headers to every cloud request.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class HeaderInterceptor(val context: Context,
                                 private val cloudCredentials: CloudCredentials,
                                 private val cloudUserAgentProvider: CloudUserAgentProvider) : Interceptor {

    override fun intercept(chain: Interceptor.Chain): okhttp3.Response {
        var request = chain.request()
        request = request.newBuilder()
                .addHeader("Accept", "application/json")
                .addHeader("User-Agent", cloudUserAgentProvider.userAgent).build()
        request = addAuthorizationHeaders(request)
        return chain.proceed(request)
    }

    private fun addAuthorizationHeaders(request: Request): Request {
        if (cloudCredentials.basicAuthorisation.isNotEmpty()) {
            return request.newBuilder()
                    .addHeader("Authorization", "Basic ${cloudCredentials.basicAuthorisation}" )
                    .build()
        }
        return request
    }
}