package com.estimote.indoorsdk_module.algorithm

import android.support.annotation.Keep

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Keep
interface ScanningIndoorLocationManager {

    /**
     * Notifies Manager to start it's positioning algorithms. Make sure to call this method before starting scanning.
     */
    fun startPositioning()

    /**
     * Stops positioning algorithms. Make sure to use this method when you are not using positioning.
     */
    fun stopPositioning()

    /**
     * In order to get estimated position from manager, you need to add listener to it.
     * Use this method to do this. Each consequent invocation of this function will override previous listener.
     */
    fun setOnPositionUpdateListener(onPositionUpdateListener: OnPositionUpdateListener)

}
