package com.estimote.indoorsdk_module.algorithm

import android.content.Context
import android.support.annotation.Keep
import com.estimote.indoorsdk_module.cloud.Location
import com.estimote.indoorsdk_module.common.extensions.translateAllCoordinatesToPositiveValues
import com.estimote.indoorsdk_module.dagger.indoor_manager.*
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import javax.inject.Inject

/**
 * Main [IndoorLocationManager] factory.
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Keep
class IndoorLocationManagerFactory {

    @Inject
    internal lateinit var indoorLocationManager: IndoorLocationManager

    /**
     * Creates [IndoorLocationManager] object that is responsible for calculating position from scans.
     * @param context application context
     * @param location [Location] object from cloud. It contains data about location.
     * @param positionUpdateIntervalMillis This will be the interval at which your [OnPositionUpdateListener] will receive updates.
     */
    fun create(context: Context, location: Location, cloudCredentials: CloudCredentials, positionUpdateIntervalMillis: Long, loggingEnabled: Boolean = false): IndoorLocationManager {
        val locationWithPositiveValues = location.translateAllCoordinatesToPositiveValues()
        DaggerIndoorLocationManagerComponent.builder()
                .analyticsModule(AnalyticsModule(context, locationWithPositiveValues, cloudCredentials))
                .configurationModule(ConfigurationModule(locationWithPositiveValues))
                .dateAndTimeModule(DateAndTimeModule())
                .filtersModule(FiltersModule(locationWithPositiveValues))
                .geometryModule(GeometryModule())
                .sensorsModule(SensorsModule(context))
                .indoorLocationManagerModule(IndoorLocationManagerModule(locationWithPositiveValues, positionUpdateIntervalMillis, loggingEnabled))
                .schedulersModule(SchedulersModule())
                .build().inject(this)
        return indoorLocationManager
    }

}