package com.estimote.indoorsdk_module.view.animation

import android.animation.PropertyValuesHolder
import android.animation.ValueAnimator
import android.view.animation.Interpolator
import com.estimote.indoorsdk_module.cloud.LocationPosition
import com.estimote.indoorsdk_module.view.IndoorLocationView.ViewLocationPosition

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class PositionAnimator(private val animationDuration: Long,
                                private val interpolator: Interpolator,
                                private val animator: ValueAnimator) {

    private val X_VALUE_KEY = "X"
    private val Y_VALUE_KEY = "Y"
    private val ORIENTATION_VALUE_KEY = "O"

    init {
        animator.duration = animationDuration
        animator.interpolator = interpolator
    }

    fun animate(startPosition: ViewLocationPosition, endPosition: ViewLocationPosition, listener: (LocationPosition) -> Unit) {
        cancelPreviousAnimationIfRunning()
        val xValueHolder = PropertyValuesHolder.ofFloat(X_VALUE_KEY, startPosition.x.toFloat(), endPosition.x.toFloat())
        val yValueHolder = PropertyValuesHolder.ofFloat(Y_VALUE_KEY, startPosition.y.toFloat(), endPosition.y.toFloat())
        val orientationValueHolder = PropertyValuesHolder.ofFloat(ORIENTATION_VALUE_KEY, endPosition.orientation.toFloat())
        animator.setValues(xValueHolder, yValueHolder, orientationValueHolder)
        animator.removeAllUpdateListeners()
        animator.addUpdateListener { animation ->
            val x = animation.getAnimatedValue(X_VALUE_KEY) as Float
            val y = animation.getAnimatedValue(Y_VALUE_KEY) as Float
            val orientation = animation.getAnimatedValue(ORIENTATION_VALUE_KEY) as Float
            listener.invoke(LocationPosition(x.toDouble(), y.toDouble(), orientation.toDouble() ))
        }
        animator.start()
    }

    private fun cancelPreviousAnimationIfRunning() {
        if (animator.isRunning) {
            animator.cancel()
        }
    }


}