package com.estimote.indoorsdk_module.analytics

import android.content.Context
import android.provider.Settings
import com.estimote.indoorsdk_module.BuildConfig
import com.estimote.indoorsdk_module.cloud.Location


/**
 * Provides object with general info about user, device and location.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class GeneralInfoProvider {

    private val PLATFORM_NAME = "Android"

    fun createGeneralInfo(context: Context, location: Location) : GeneralInfo {
        return GeneralInfo(context.packageName, getDeviceId(context), getDeviceModel(), getSdkVersion(), PLATFORM_NAME, getLocationCloudId(location))
    }

    private fun getDeviceId(context: Context) : String {
        return Settings.Secure.getString(context.contentResolver, Settings.Secure.ANDROID_ID)
    }

    private fun getDeviceModel(): String {
        if (android.os.Build.MODEL.startsWith(android.os.Build.MANUFACTURER)) {
            return android.os.Build.MODEL
        } else {
            return android.os.Build.MANUFACTURER + " " + android.os.Build.MODEL
        }
    }

    private fun getSdkVersion(): String {
        return BuildConfig.VERSION_NAME
    }

    private fun getLocationCloudId(location: Location): String {
        return "\"${location.name}\" (${location.beacons.size}, \"${location.identifier}\")"
    }

}