package com.estimote.indoorsdk_module.algorithm.filter

import com.estimote.indoorsdk_module.algorithm.model.BeaconWithRssi
import com.estimote.indoorsdk_module.algorithm.model.ScannedBeacon
import com.estimote.indoorsdk_module.cloud.LocationBeacon

/**
 * Maps scanned beacon data to location beacons.
 * Finds which of scanned beacons are belonging to the location and joins their RSSI with location position (x,y)
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class ScannedBeaconToLocationBeaconMapper {

    fun mapScannedBeaconsToLocationBeacons(scannedBeacons: List<ScannedBeacon>, locationBeacons: List<LocationBeacon>): List<BeaconWithRssi> {
        val mutableList = mutableListOf<BeaconWithRssi>()
        scannedBeacons.forEach {
            val beaconWithRssi = mapScannedBeaconToLocationBeacon(it, locationBeacons)
            if (beaconWithRssi != null) mutableList.add(beaconWithRssi)
        }
        return mutableList.toList()
    }

    fun mapScannedBeaconToLocationBeacon(scannedBeacon: ScannedBeacon, locationBeacons: List<LocationBeacon>): BeaconWithRssi? {
        val locationBeacon = locationBeacons.find { it.beacon.mac.equals(scannedBeacon.id, ignoreCase = true) }
        return if (locationBeacon != null) {
            BeaconWithRssi(locationBeacon, scannedBeacon.rssi, scannedBeacon.timestamp)
        } else null
    }


}