package com.estimote.indoorsdk_module.algorithm

import android.support.annotation.Keep
import com.estimote.indoorsdk_module.dagger.indoor_manager.DaggerScannerComponent
import com.estimote.indoorsdk_module.dagger.indoor_manager.ScanningModule
import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import javax.inject.Inject

/**
 * Factory for creating [ScanningIndoorLocationManager] objects.
 * Do not use it directly - use [IndoorLocationManagerBuilder]
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Keep
class ScanningIndoorLocationManagerFactory {

    @Inject
    internal lateinit var scanningIndoorLocationManagerWrapper: ScanningEstimoteIndoorLocationManager

    /**
     * @param bluetoothScanner scanner object to wrap [IndoorLocationManager] object with.
     * @param indoorLocationManager indoor location manager object to be provided with scans from [BluetoothScanner]
     */
    fun wrapIndoorLocationManagerWithDefaultScanner(bluetoothScanner: BluetoothScanner,
                                                    indoorLocationManager: IndoorLocationManager,
                                                    loggingEnabled: Boolean = false,
                                                    onErrorAction: (Throwable) -> Unit): ScanningIndoorLocationManager {
        DaggerScannerComponent.builder()
                .scanningModule(ScanningModule(bluetoothScanner, indoorLocationManager, loggingEnabled, onErrorAction))
                .build().inject(this)
        return scanningIndoorLocationManagerWrapper
    }


}