package com.estimote.indoorsdk_module.algorithm

import com.estimote.indoorsdk_module.logging.IndoorLogger
import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.internal_plugins_api.scanning.ScanHandler

internal class ScanningEstimoteIndoorLocationManager(private val indoorLocationManager: IndoorLocationManager,
                                                     private val bluetoothScanner: BluetoothScanner,
                                                     private val logger: IndoorLogger,
                                                     private val onErrorAction: (Throwable) -> Unit) : ScanningIndoorLocationManager {

    private var estimoteLocationScanHandler: ScanHandler? = null
    private var ibeaconScanHandler: ScanHandler? = null

    override fun startPositioning() {
        stopScanning()
        indoorLocationManager.startPositioning()
        estimoteLocationScanHandler = bluetoothScanner.estimoteLocationScan()
                .withLowLatencyPowerMode()
                .withOnPacketFoundAction { indoorLocationManager.onScannedLocationPackets(it) }
                .withOnScanErrorAction{
                    stopScanning()
                    logger.error("EstimoteLocation scan error. Message: ${it.message}")
                    onErrorAction(it)
                }
                .start()
        ibeaconScanHandler = bluetoothScanner.beaconScan()
                .withLowLatencyPowerMode()
                .withOnPacketFoundAction { indoorLocationManager.onScannedBeaconPackets(it) }
                .withOnScanErrorAction{
                    stopScanning()
                    logger.error("iBeacon scan error. Message: ${it.message}")
                    onErrorAction(it)
                }
                .start()
    }

    override fun stopPositioning() {
        stopScanning()
        indoorLocationManager.stopPositioning()
    }

    override fun setOnPositionUpdateListener(onPositionUpdateListener: OnPositionUpdateListener) {
        indoorLocationManager.setOnPositionUpdateListener(onPositionUpdateListener)
    }

    private fun stopScanning() {
        estimoteLocationScanHandler?.stop()
        ibeaconScanHandler?.stop()
    }

}