package com.estimote.indoorsdk_module.algorithm

import android.support.annotation.Keep
import com.estimote.internal_plugins_api.scanning.Beacon
import com.estimote.internal_plugins_api.scanning.EstimoteLocation


/**
 * Main object for estimating position from scanned beacons.
 * You should provide it with scanned beacons using method [IndoorLocationManager.onScannedPackets].d
 * You can scan beacons using BluetoothScanner from Estimote Scanning SDK.
 * Computed (x,y) coordinates will be delivered to your listener - don't forget to set it using [IndoorLocationManager.setOnPositionUpdateListener]!
 * You can use [EstimoteIndoorHelper.setupIndoorPositioning] to quickly setup listeners between view, manager and beacon scanner.
 *
 * @see OnPositionUpdateListener
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Keep
interface IndoorLocationManager {

    /**
     * Notifies Manager to start it's positioning algorithms. Make sure to call this method before starting scanning.
     */
    fun startPositioning()

    /**
     * Stops positioning algorithms. Make sure to use this method when you are not using positioning.
     */
    fun stopPositioning()

    /**
     * In order to get estimated position from manager, you need to add listener to it.
     * Use this method to do this. Each consequent invocation of this function will override previous listener.
     */
    fun setOnPositionUpdateListener(onPositionUpdateListener: OnPositionUpdateListener)

    /**
     * Method for passing scanned Estimote Location packet data.
     * You need to have beacons that are able to advertise this protocol packets.
     */
    fun onScannedLocationPackets(estimoteLocationPacket: EstimoteLocation)

    /**
     * Method for passing scanned Beacon packets of protocol from company which is named after the popular fruit.
     * Some old Indoor Location deployments are using still Beacon packet for doing Indoor Navigation.
     * New deployments use only [EstimoteLocation] packets.
     *
     */
    fun onScannedBeaconPackets(beaconPacket: Beacon)

}