package com.estimote.indoorsdk_module.dagger.indoor_manager

import android.content.Context
import android.hardware.SensorManager
import com.estimote.indoorsdk_module.algorithm.sensor.MotionDetector
import com.estimote.indoorsdk_module.algorithm.sensor.ObservableSensors
import com.estimote.indoorsdk_module.algorithm.sensor.StepMotionDetector
import com.estimote.indoorsdk_module.algorithm.sensor.StepMotionDetectorSubscriber
import com.estimote.indoorsdk_module.common.config.MainConfig
import com.estimote.indoorsdk_module.common.config.MotionConfig
import com.estimote.indoorsdk_module.common.time.Timer
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class SensorsModule(private val context: Context) {

    @Provides
    @Singleton
    fun provideSensorManager(): SensorManager = context.getSystemService(Context.SENSOR_SERVICE) as SensorManager

    @Provides
    @Singleton
    fun provideObservableSensors(sensorManager: SensorManager): ObservableSensors = ObservableSensors(sensorManager)

    @Provides
    @Singleton
    fun provideMotionDetectionSubscriber(observableSensors: ObservableSensors, motionDetector: MotionDetector) : StepMotionDetectorSubscriber = StepMotionDetectorSubscriber(observableSensors, motionDetector)

    @Provides
    @Singleton
    fun provideMotionDetector(timer: Timer,
                              mainConfig: MainConfig): MotionDetector {
        return StepMotionDetector(timer, MotionConfig(mainConfig))
    }
}