package com.estimote.indoorsdk_module.dagger.indoor_manager

import com.estimote.indoorsdk_module.algorithm.IndoorLocationManagerFactory
import dagger.Component
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */

@Singleton
@Component(modules = arrayOf(
        GeometryModule::class,
        FiltersModule::class,
        AnalyticsModule::class,
        DateAndTimeModule::class,
        ConfigurationModule::class,
        SensorsModule::class,
        IndoorLocationManagerModule::class,
        SchedulersModule::class
))
internal interface IndoorLocationManagerComponent {

    fun inject(indoorLocationManagerFactory: IndoorLocationManagerFactory)

}