package com.estimote.indoorsdk_module.common.time

import java.text.SimpleDateFormat
import java.util.*

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class SimpleDateFormatter(locale: Locale) : DateFormatter {

    val dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ"
    val dateFormatter = SimpleDateFormat(dateFormat, locale)

    override fun millisToDate(millis: Long): String {
        return dateFormatter.format(Date(millis))
    }
}