package com.estimote.indoorsdk_module.algorithm.distance

import com.estimote.indoorsdk_module.algorithm.model.BeaconWithDistance
import com.estimote.indoorsdk_module.algorithm.model.BeaconWithRssi
import com.estimote.indoorsdk_module.common.config.Config
import com.estimote.indoorsdk_module.common.config.ConfigFactory

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class SimpleRssiToDistanceCalculator(private val configFactory: ConfigFactory) : RssiToDistanceCalculator {

    override fun calculateDistance(beaconWithRssi: BeaconWithRssi): BeaconWithDistance {
        val distance = calculateDistanceFromRssi(beaconWithRssi.rssi, configFactory.getConfig())
        return BeaconWithDistance(beaconWithRssi.beacon, distance, beaconWithRssi.timestamp)
    }

    private fun calculateDistanceFromRssi(rssi: Int, config: Config): Double {
        val measuredPower = config.getBeaconMeasuredPower() + config.getBeaconMeasuredPowerOffset() + config.getBeaconMeasuredPowerCorrection()
        return Math.exp((rssi - measuredPower) / config.getRssiToDistancePropagationConstant())
    }

}