package com.estimote.indoorsdk_module.common.threading

import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class SdkSchedulerProvider : SchedulerProvider {

    override fun io() = Schedulers.io()

    override fun ui() = AndroidSchedulers.mainThread()

    override fun computation() = Schedulers.computation()

    override fun newThread() = Schedulers.newThread()
}