package com.estimote.indoorsdk_module.cloud

import android.support.annotation.Keep

/**
 * Communicates response from a server or an error. Only one method will be
 * invoked in response to a given request.
 * Callback methods are executed on application's main thread.
 *
 * @param <T> Response type.
 * @author Estimote Inc. (contact@estimote.com)
</T> */
@Keep
interface CloudCallback<in T> {

    /** Successful response.  */
    fun success(t: T)

    /** Unsuccessful response.  */
    fun failure(serverException: EstimoteCloudException)
}